function indices=cellIndices(I,dims,orderstr)
% indices=cellIndices(I,dims,orderstr)
%
% get the indices in an n-dimensional grid given by its dims=size(M)
% orderstr is a string to change the order of the columns using L R C
% for layer (initially col 3), row (initially col 1) and C (initially col 2)
% if number of dimensions through dims <>3, then orderstr is ignored.
% Example: make a LRC list of the nodes where 3D matrix A==-1
%  A=ones(4,5,6); A(:,1,1)=-1;
%  indices=cellIndices(find(A==-1),size(A),'LRC')
%
% TO 090317 091119


% Copyright 2009 Theo Olsthoorn, TU-Delft and Waternet, without any warranty
% under free software foundation GNU license version 3 or later

if length(dims)<length(orderstr), dims(end+1:length(orderstr))=1; end
    
indices=zeros(length(I),length(dims));
for i=1:length(I)
    n=I(i)-1;
    for idim=1:length(dims)
        indices(i,idim)=rem(n,dims(idim))+1;
        n=(n-(indices(i,idim)-1))/dims(idim);
    end
end

if exist('orderstr','var') && length(orderstr)==3
    switch upper(orderstr)
        case 'LRC', order=[3 1 2];
        case 'LCR', order=[3 2 1];
        case 'RLC', order=[1 3 2];
        case 'RCL', order=[1 2 3];
        case 'CLR', order=[2 3 1];
        case 'CRL', order=[2 1 3];
        otherwise error(sprintf('Order string <<%s>> in cellIndices',orderstr));
    end
    indices=indices(:, order);  % switch colmns
end
